#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Ganti Nama Bimbel Anda', '6281234567890', 'ganti.email.anda@gmail.com', 'Ganti alamat Anda', 'Logo-1752136431.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=608 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3836 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3817, 1, '2001:448a:50e2:8b75:f09c:f7fb:bb', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Logout', '2025-07-09 22:54:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3818, 1, '2001:448a:50e2:8b75:f09c:f7fb:bb', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-07-09 22:54:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3819, 1, '2001:448a:50e2:8b75:f09c:f7fb:bb', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Logout', '2025-07-09 23:18:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3820, 1, '2001:448a:50e2:8b75:ac45:81b:be3', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-09 23:36:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3821, 1, '114.125.116.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Logout', '2025-07-10 11:04:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3822, 1, '114.125.116.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 13:23:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3823, 1, '2001:448a:50e2:8b75:b59a:39ae:5c', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-07-10 14:15:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3824, 1, '2001:448a:50e2:8b75:b59a:39ae:5c', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Logout', '2025-07-10 14:28:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3825, 1, '2001:448a:50e2:8b75:b9b3:ca05:2b', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 14:31:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3826, 1, '114.125.116.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Logout', '2025-07-10 15:28:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3827, 1, '114.125.116.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 15:33:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3828, 1, '114.125.116.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Logout', '2025-07-10 15:33:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3829, 1, '2001:448a:50e2:8b75:edd3:a4d3:cc', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Login', '2025-07-10 16:00:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3830, 1, '182.1.98.99', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 18:33:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3831, 1, '2001:448a:50e2:8b75:b59a:39ae:5c', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-07-10 19:29:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3832, 1, '2001:448a:50e2:8b75:75ca:f13a:ef', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Logout', '2025-07-10 22:45:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3833, 1, '2001:448a:50e2:8b75:75ca:f13a:ef', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-07-11 12:28:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3834, 1, '2001:448a:50e2:8b75:75ca:f13a:ef', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Logout', '2025-07-11 13:15:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3835, 1, '2001:448a:50e2:8b75:8847:ebe4:1f', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-07-11 20:47:39');


#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'demo', '2025-07-16');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=450 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4301 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Yaniek Rahayu Isnaningtyas', 'Perempuan', '6285730153434', 'ganti.email.anda@gmail.com', 'Ganti alamat Anda', 'Owner', '$2y$10$BKzKK1CDZVZTjEa36mIntuVMX.przo0S7m9xyFbDUblyxqkcfOMNO', 'Profil-1751466985.png', 'blue', 'Administrator', 'Ya', '2023-05-20 09:36:23');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (9, 'Pegawai', 'Perempuan', '6281234567890', 'pegawai@gmail.com', 'Jombang, Jawa Timur', 'Pegawai', '$2y$10$qb2UtrAyR60leuLpeNChNOFFLQevL0S6mzyubQcM6.zo9t7H3qK6S', 'no-image.png', 'blue', 'Pegawai', 'Ya', '2025-07-11 20:50:21');


